#!/bin/bash

typeset jarFile=$1
typeset jarFileBasename=`basename $jarFile`

typeset base=deployMockJar
typeset deployScript=${base}.sh
typeset deployLog=${base}.log
typeset errorLog=${base}.error
typeset deploymentsDir=$VAGRANT_DIR/deployments

rm -f $errorLog
if [ -z $VAGRANT_DIR ] || [ ! -r $VAGRANT_DIR/Vagrantfile ] ; then
	echo '$VAGRANT_DIR must be defined and contain a valid Vagrantfile.  Aborted.' > $errorLog
	exit 1
fi

cat <<-'EOF' > $VAGRANT_DIR/$deployScript
#!/bin/bash

typeset command="java -jar /vagrant/deployments/$1"

ps -ef | grep "java -jar /vagrant/deployments/MviService" | grep -v grep | sed "s/[ ]\{1,\}/ /g" | cut -d" " -f2 | \
while read pid; do
	echo killing $pid ...
	kill -9 $pid
done

echo "Running $command ..."
$command &
EOF

chmod +x $VAGRANT_DIR/$deployScript
mkdir -p $deploymentsDir
cp $jarFile $deploymentsDir
cd $VAGRANT_DIR
vagrant ssh vamf_weblogic --command "/vagrant/$deployScript $jarFileBasename > $deployLog 2>&1"
